(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82587,       1638]
NotebookOptionsPosition[     79987,       1551]
NotebookOutlinePosition[     80594,       1573]
CellTagsIndexPosition[     80551,       1570]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "\n",
 StyleBox["Z , Randles circuit",
  FontFamily->"Arial",
  FontSize->20]
}], "Title",
 CellChangeTimes->{
  3.475865912414785*^9, {3.475865943298551*^9, 3.475865955268236*^9}, {
   3.4758660429022484`*^9, 3.475866079428337*^9}, {3.475866316276884*^9, 
   3.4758663189490376`*^9}, {3.4899180970833187`*^9, 
   3.4899181046177497`*^9}, {3.521476712575059*^9, 3.5214767156602354`*^9}, {
   3.5214771897083497`*^9, 3.521477193004538*^9}, {3.5218873523293095`*^9, 
   3.5218873564375443`*^9}, {3.570533035842108*^9, 3.5705330403803673`*^9}, 
   3.5705382339774246`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "spell"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.4899223475414314`*^9, 3.489922372043833*^9}, {
  3.489922422316708*^9, 3.4899225446377044`*^9}, {3.4899231471981688`*^9, 
  3.489923148842263*^9}, {3.5218889390790663`*^9, 3.521888942727275*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Cdl\"\>", ",", "\<\"lom\"\>", ",", "\<\"lom$\"\>", 
   ",", "\<\"lZM\"\>", ",", "\<\"Rct\"\>", ",", "\<\"Rs\"\>", 
   ",", "\<\"Yt\"\>", ",", "\<\"Z1\"\>", ",", "\<\"Z2\"\>", ",", "\<\"ZM\"\>",
    ",", "\<\"Zt\"\>", ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[CurlyPhi]\"\>", 
   ",", "\<\"\[Omega]\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.4899224480931826`*^9, 3.4899224680093217`*^9}, {
   3.4899225132789106`*^9, 3.489922572867319*^9}, 3.4899227588979597`*^9, 
   3.4899229525470357`*^9, {3.489923150031331*^9, 3.4899231591338515`*^9}, 
   3.4899232103387804`*^9, {3.4899232425756245`*^9, 3.489923428631266*^9}, 
   3.4899235748226275`*^9, 3.489924077427375*^9, 3.4899241356177034`*^9, 
   3.4899242249058104`*^9, {3.4899242571656556`*^9, 3.4899242784588737`*^9}, 
   3.489924406675207*^9, 3.489924454993971*^9, 3.489924529655241*^9, 
   3.4899245705055776`*^9, 3.489924620959463*^9, 3.5214767197844715`*^9, 
   3.521482241373288*^9, 3.5218881575273647`*^9, 3.5218884336581583`*^9, 
   3.521888592062218*^9, 3.521888625525132*^9, 3.5218889436613283`*^9, 
   3.521889196707802*^9, 3.521889326388219*^9, 3.5218896353968935`*^9, 
   3.5218899920282917`*^9, 3.5218901311722507`*^9, 3.52189052996806*^9, 
   3.5218906339220057`*^9, 3.5218909004972534`*^9, 3.5218923925335927`*^9, 
   3.5218924780914865`*^9, 3.52189263061121*^9, 3.521893227968377*^9, 
   3.521902173010004*^9, 3.521904360150101*^9, 3.521905128757063*^9, 
   3.52191141682472*^9, 3.570533733413007*^9, 3.570533910188118*^9, 
   3.57053934340388*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zt", "=", 
  RowBox[{"Rs", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"Rct", "+", 
         RowBox[{"\[Sigma]", "/", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"\[ImaginaryI]", "*", "\[Omega]"}], "]"}]}]}], ")"}]}], 
      "+", 
      RowBox[{"\[ImaginaryI]", "*", "\[Omega]", "*", "Cdl"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4756024908337126`*^9, 3.4756025132197514`*^9}, 
   3.475602710568898*^9, 3.4756028164586835`*^9, {3.475604014994418*^9, 
   3.4756040188336377`*^9}, {3.4756041023064117`*^9, 3.475604103042454*^9}, 
   3.4756042857619047`*^9, {3.4758607424280787`*^9, 3.4758607461322904`*^9}, {
   3.4758653363428354`*^9, 3.4758654700724845`*^9}, {3.4758656911581297`*^9, 
   3.475865692438203*^9}, {3.4758657258471136`*^9, 3.475865727415203*^9}, {
   3.4758660945682034`*^9, 3.4758662093987713`*^9}, 3.4758662524252324`*^9, 
   3.4758663224082355`*^9, {3.4758664993513556`*^9, 3.475866500230406*^9}, {
   3.4758665335913143`*^9, 3.47586653421535*^9}, {3.4759198606664486`*^9, 
   3.4759198680258694`*^9}, {3.4899183954853864`*^9, 
   3.4899186045743456`*^9}, {3.4899186811347246`*^9, 3.4899186819507713`*^9}, 
   3.48991949963054*^9, 3.489920529485444*^9, 3.4899208179169416`*^9, 
   3.4899211413724422`*^9, {3.4899227490373955`*^9, 3.4899227507164917`*^9}, {
   3.4899234830853806`*^9, 3.4899234915648656`*^9}, {3.5214767369024506`*^9, 
   3.5214767910695486`*^9}, {3.5218874144458623`*^9, 3.521887421799283*^9}, {
   3.521888146758748*^9, 3.5218881523740697`*^9}, {3.5705330475077753`*^9, 
   3.5705331045800395`*^9}, 3.5705337217633405`*^9, {3.570533914131343*^9, 
   3.5705339276821184`*^9}, {3.5705383096987553`*^9, 3.570538399684902*^9}, {
   3.570538455217078*^9, 3.5705385242120247`*^9}, {3.5705385781811113`*^9, 
   3.5705386130431056`*^9}, {3.5705386973959303`*^9, 
   3.5705388328526783`*^9}, {3.5705388686457253`*^9, 3.5705388937151594`*^9}}],

Cell[BoxData[
 RowBox[{"Rs", "+", 
  FractionBox["1", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"Rct", "+", 
      FractionBox["\[Sigma]", 
       SqrtBox[
        RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]]}]], "+", 
    RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}]], "Output",
 CellChangeTimes->{3.5705388964243145`*^9, 3.5705393435168867`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Yt", "=", 
  RowBox[{"1", "/", "Zt"}]}]], "Input",
 CellChangeTimes->{{3.5705392072310915`*^9, 3.5705392132664366`*^9}}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Rs", "+", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Rct", "+", 
       FractionBox["\[Sigma]", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]]]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", "Cdl", " ", "\[Omega]"}]}]]}]]], "Output",
 CellChangeTimes->{3.5705392149565334`*^9, 3.570539343543888*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Rs", "=", "10"}], "\[IndentingNewLine]", 
 RowBox[{"Rct", "=", "50"}], "\[IndentingNewLine]", 
 RowBox[{"Cdl", "=", 
  RowBox[{"25", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "6"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"\[Sigma]", "=", "10"}]}], "Input",
 CellChangeTimes->{{3.5218874289926944`*^9, 3.521887476006384*^9}, {
  3.5218880815430183`*^9, 3.5218880856382523`*^9}, {3.5705331185628395`*^9, 
  3.570533164322457*^9}, {3.5705389117301893`*^9, 3.570538957625815*^9}}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.570538959010894*^9, 3.5705393435858903`*^9}],

Cell[BoxData["50"], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.570538959010894*^9, 3.57053934358889*^9}],

Cell[BoxData[
 FractionBox["1", "40000"]], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.570538959010894*^9, 3.5705393435948906`*^9}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.570538959010894*^9, 3.5705393436018915`*^9}],

Cell[BoxData["50"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, {
   3.570538959014894*^9, 3.570538977091928*^9}}],

Cell[BoxData[
 FractionBox["1", "40000"]], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.570538959022895*^9}],

Cell[BoxData["10"], "Output",
 CellChangeTimes->{
  3.5218874777724843`*^9, 3.5218881664108725`*^9, 3.5218884337651644`*^9, 
   3.5218885921592236`*^9, 3.5218886256331387`*^9, 3.5218889574351163`*^9, 
   3.521889196798807*^9, 3.5218893264732237`*^9, 3.5218896354938993`*^9, 
   3.5218899921302977`*^9, 3.521890131284257*^9, 3.5218905300670657`*^9, 
   3.5218906340210114`*^9, 3.52189090061626*^9, 3.5218923926505995`*^9, 
   3.521892478196492*^9, 3.5218926307522182`*^9, 3.521893228074383*^9, 
   3.5219021732630186`*^9, 3.5219043602991095`*^9, 3.5219051288540688`*^9, 
   3.5219114170507326`*^9, 3.5705331658685455`*^9, 3.570533308689714*^9, {
   3.570533739287343*^9, 3.570533745428694*^9}, 3.5705339331194296`*^9, 
   3.5705389590268946`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Omega]", "=", 
  RowBox[{"10", "^", "lom"}]}]], "Input",
 CellChangeTimes->{{3.489919493284177*^9, 3.489919514409385*^9}, {
  3.489919545036137*^9, 3.4899195457091756`*^9}, {3.4899205360618205`*^9, 
  3.4899205457093725`*^9}, {3.489920600029479*^9, 3.489920601662573*^9}, {
  3.4899206933568172`*^9, 3.4899207059655385`*^9}, {3.489922938429228*^9, 
  3.489922940494346*^9}, {3.4899234965901527`*^9, 3.4899234985572653`*^9}, {
  3.489924026686473*^9, 3.4899240707649937`*^9}, {3.521476802942228*^9, 
  3.5214768260145473`*^9}, {3.5218875214459825`*^9, 3.521887541750144*^9}, {
  3.570533182450494*^9, 3.5705331884978395`*^9}, {3.570538989555641*^9, 
  3.570538993398861*^9}}],

Cell[BoxData[
 SuperscriptBox["10", "lom"]], "Output",
 CellChangeTimes->{{3.4899240733261404`*^9, 3.489924095086385*^9}, 
   3.4899241356907077`*^9, 3.4899242249958153`*^9, {3.48992425724566*^9, 
   3.4899242785248775`*^9}, 3.489924406761212*^9, 3.4899244550659747`*^9, 
   3.4899245297352457`*^9, 3.489924570574581*^9, 3.48992462107047*^9, 
   3.521476830184786*^9, 3.5214822414992957`*^9, 3.521887544764316*^9, 
   3.521888169612056*^9, 3.5218884337941656`*^9, 3.521888592186225*^9, 
   3.52188862566414*^9, 3.5218889628424253`*^9, 3.5218891968228083`*^9, 
   3.5218893264992256`*^9, 3.5218896355229006`*^9, 3.521889992157299*^9, 
   3.521890131309258*^9, 3.5218905300950675`*^9, 3.521890634048013*^9, 
   3.5218909006512623`*^9, 3.5218923926816015`*^9, 3.521892478228494*^9, 
   3.5218926307912207`*^9, 3.521893228108385*^9, 3.52190217329202*^9, 
   3.5219043603261113`*^9, 3.5219051288790703`*^9, 3.5219114170777345`*^9, 
   3.570533189753911*^9, 3.570533311724888*^9, 3.5705337476078186`*^9, 
   3.5705339359775925`*^9, 3.5705389962790256`*^9, 3.570539343635893*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z1", "=", 
  RowBox[{"Re", "[", "Zt", "]"}]}]], "Input",
 CellChangeTimes->{{3.5705390807978597`*^9, 3.570539094212627*^9}}],

Cell[BoxData[
 RowBox[{"10", "+", 
  RowBox[{"Re", "[", 
   FractionBox["1", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{"-", "6"}], "+", "lom"}]], " ", 
      SuperscriptBox["5", 
       RowBox[{
        RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
     FractionBox["1", 
      RowBox[{"50", "+", 
       FractionBox["10", 
        SqrtBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}]], "Output",
 CellChangeTimes->{3.57053909951593*^9, 3.570539343664895*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Z2", "=", 
  RowBox[{"Im", "[", "Zt", "]"}]}]], "Input",
 CellChangeTimes->{{3.570539102595106*^9, 3.5705391116676254`*^9}}],

Cell[BoxData[
 RowBox[{"Im", "[", 
  FractionBox["1", 
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "6"}], "+", "lom"}]], " ", 
     SuperscriptBox["5", 
      RowBox[{
       RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
    FractionBox["1", 
     RowBox[{"50", "+", 
      FractionBox["10", 
       SqrtBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]], "Output",
 CellChangeTimes->{3.570539113579735*^9, 3.5705393437208977`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ZM", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Z1", "^", "2"}], "+", 
    RowBox[{"Z2", "^", "2"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"lZM", "=", 
  RowBox[{"Log10", "[", "ZM", "]"}]}]}], "Input",
 CellChangeTimes->{{3.521887890915115*^9, 3.521887929190304*^9}, 
   3.5218923814469585`*^9, 3.5218924691589756`*^9, {3.570533364498906*^9, 
   3.5705333800667963`*^9}, {3.570533795154538*^9, 3.570533808598307*^9}, 
   3.5705353116842785`*^9}],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Im", "[", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["2", 
         RowBox[{
          RowBox[{"-", "6"}], "+", "lom"}]], " ", 
        SuperscriptBox["5", 
         RowBox[{
          RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
       FractionBox["1", 
        RowBox[{"50", "+", 
         FractionBox["10", 
          SqrtBox[
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["10", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}], ")"}], 
    "2"]}]]], "Output",
 CellChangeTimes->{3.5218879306973906`*^9, 3.521888187048053*^9, 
  3.521888433903172*^9, 3.5218885922992315`*^9, 3.5218886257781467`*^9, 
  3.5218890772979717`*^9, 3.521889196916814*^9, 3.521889326604232*^9, 
  3.5218896356429076`*^9, 3.5218899922683053`*^9, 3.5218901314182644`*^9, 
  3.5218905302070737`*^9, 3.521890634149019*^9, 3.52189090078327*^9, 
  3.521892392806608*^9, 3.521892478362502*^9, 3.5218926309522295`*^9, 
  3.5218932282583933`*^9, 3.521902173415027*^9, 3.521904360433118*^9, 
  3.5219051289750757`*^9, 3.521911417212742*^9, 3.570533382328926*^9, 
  3.5705337565763316`*^9, 3.570533810451413*^9, 3.5705339491663475`*^9, 
  3.5705353170155835`*^9, 3.5705390340861883`*^9, 3.570539119334064*^9, 
  3.5705393437499*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"Im", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["10", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"10", "+", 
        RowBox[{"Re", "[", 
         FractionBox["1", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["2", 
             RowBox[{
              RowBox[{"-", "6"}], "+", "lom"}]], " ", 
            SuperscriptBox["5", 
             RowBox[{
              RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
           FractionBox["1", 
            RowBox[{"50", "+", 
             FractionBox["10", 
              SqrtBox[
               RowBox[{"\[ImaginaryI]", " ", 
                SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}], ")"}], 
      "2"]}]], "]"}], 
  RowBox[{"Log", "[", "10", "]"}]]], "Output",
 CellChangeTimes->{3.5218879306973906`*^9, 3.521888187048053*^9, 
  3.521888433903172*^9, 3.5218885922992315`*^9, 3.5218886257781467`*^9, 
  3.5218890772979717`*^9, 3.521889196916814*^9, 3.521889326604232*^9, 
  3.5218896356429076`*^9, 3.5218899922683053`*^9, 3.5218901314182644`*^9, 
  3.5218905302070737`*^9, 3.521890634149019*^9, 3.52189090078327*^9, 
  3.521892392806608*^9, 3.521892478362502*^9, 3.5218926309522295`*^9, 
  3.5218932282583933`*^9, 3.521902173415027*^9, 3.521904360433118*^9, 
  3.5219051289750757`*^9, 3.521911417212742*^9, 3.570533382328926*^9, 
  3.5705337565763316`*^9, 3.570533810451413*^9, 3.5705339491663475`*^9, 
  3.5705353170155835`*^9, 3.5705390340861883`*^9, 3.570539119334064*^9, 
  3.5705393437539*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Z1", ",", "Z2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "3"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4756034305039873`*^9, 3.4756034317770596`*^9}, {
   3.4756034944846463`*^9, 3.475603513969761*^9}, {3.475603551473906*^9, 
   3.475603587393961*^9}, 3.4756036488824778`*^9, {3.4756036989943438`*^9, 
   3.4756037027855606`*^9}, {3.4756039087223396`*^9, 
   3.4756039240022135`*^9}, {3.475603989492959*^9, 3.475604001249632*^9}, {
   3.475604151650234*^9, 3.4756041615057983`*^9}, {3.475604357794025*^9, 
   3.47560439371408*^9}, {3.475605209794757*^9, 3.4756052162581263`*^9}, {
   3.4756054334265475`*^9, 3.475605473281827*^9}, {3.475605514436181*^9, 
   3.4756055396506233`*^9}, 3.475865811559016*^9, 3.4758664622142315`*^9, 
   3.4899210018204603`*^9, {3.489921220908992*^9, 3.48992123574084*^9}, {
   3.5214770962080016`*^9, 3.521477119023307*^9}, {3.521888419623355*^9, 
   3.5218884200383787`*^9}, {3.521889136119336*^9, 3.521889146198913*^9}, 
   3.521905292455426*^9, 3.521911388120078*^9, {3.5705338870747957`*^9, 
   3.570533898082425*^9}, {3.5705339800831156`*^9, 3.570534005494569*^9}, 
   3.570539142100366*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VG8XAHDrjH1fKqIY+55lZgjHGuGOLUsIUSplKclSVCiklKylUpIl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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 283.6037387458339}, {-100.71512383712691`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021738590527`*^9, 3.5219043608151393`*^9, 3.521905129375098*^9, 
   3.521905294481542*^9, 3.5219114176727686`*^9, 3.5705339009055867`*^9, {
   3.5705339734567366`*^9, 3.570533982628261*^9}, 3.5705340217695*^9, 
   3.5705340653729935`*^9, 3.570539146228602*^9, 3.570539343801903*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[CurlyPhi]", "=", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"Z2", "/", "Z1"}], "]"}], "*", 
   RowBox[{"180", "/", "\[Pi]"}]}]}]], "Input",
 CellChangeTimes->{{3.5219007065651283`*^9, 3.5219007065841293`*^9}, {
  3.5705340884983163`*^9, 3.5705341365780663`*^9}, {3.5705342253151417`*^9, 
  3.570534229010353*^9}, {3.570535226003378*^9, 3.5705352276364717`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"180", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"Im", "[", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["2", 
          RowBox[{
           RowBox[{"-", "6"}], "+", "lom"}]], " ", 
         SuperscriptBox["5", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
        FractionBox["1", 
         RowBox[{"50", "+", 
          FractionBox["10", 
           SqrtBox[
            RowBox[{"\[ImaginaryI]", " ", 
             SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}], 
     RowBox[{"10", "+", 
      RowBox[{"Re", "[", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SuperscriptBox["2", 
           RowBox[{
            RowBox[{"-", "6"}], "+", "lom"}]], " ", 
          SuperscriptBox["5", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "lom"}]]}], "+", 
         FractionBox["1", 
          RowBox[{"50", "+", 
           FractionBox["10", 
            SqrtBox[
             RowBox[{"\[ImaginaryI]", " ", 
              SuperscriptBox["10", "lom"]}]]]}]]}]], "]"}]}]], "]"}]}], 
  "\[Pi]"]], "Output",
 CellChangeTimes->{3.5705341416623573`*^9, 3.5705342311404753`*^9, 
  3.570535231352684*^9, 3.570539161852496*^9, 3.570539343825904*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "\[CurlyPhi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758610857867174`*^9, 3.4758610994945016`*^9}, {
   3.47586139511141*^9, 3.4758614066940727`*^9}, 3.475861522949722*^9, {
   3.475861586262343*^9, 3.475861623062448*^9}, 3.4758639548218164`*^9, {
   3.475864446741953*^9, 3.4758644503101573`*^9}, {3.4758646109663463`*^9, 
   3.4758646390459523`*^9}, {3.4758646771931343`*^9, 3.4758646914299483`*^9}, 
   3.4758665906145754`*^9, 3.4759254965058002`*^9, 3.4899212624123654`*^9, {
   3.4899227056129117`*^9, 3.4899227097861505`*^9}, 3.5214822947193394`*^9, {
   3.521888447014922*^9, 3.521888491815484*^9}, 3.521911393096363*^9, {
   3.5705341597473917`*^9, 3.5705341793945155`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtmnc8VX/8x61rXPNukpWQPRoadD7GvSlRRKSMlIwyUkkUEilJopCdEkpS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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{-6., 6.}, {-45.63820076931004, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.5219021739270563`*^9, 3.5219043608731422`*^9, 
  3.5219051294511027`*^9, 3.5219114177597733`*^9, 3.570534181935661*^9, 
  3.5705342359007473`*^9, 3.5705352363639708`*^9, 3.5705391662477474`*^9, 
  3.5705393439019084`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.521900703764968*^9, 3.5219007037809687`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lom", ",", "lZM"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4758647127111654`*^9, 3.475864726693966*^9}, {
   3.4758648002301717`*^9, 3.475864817174141*^9}, {3.521888509415491*^9, 
   3.5218885326958227`*^9}, 3.5219113972395997`*^9, {3.5705352641465597`*^9, 
   3.570535276547269*^9}, {3.5705353430120707`*^9, 3.5705353473623195`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt2nk41N/3AHB7djNjFipaRKENpUSfc1JJkSQKiSwhKRUpS5TK1iYpQrZk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     "]]}},
  Axes->True,
  AxesOrigin->{0, 1.},
  Method->{},
  PlotRange->{{-6., 6.}, {1.000004863842973, 4.001842456695615}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5219021739650583`*^9, 3.521904360913145*^9, 3.5219051295031056`*^9, 
   3.5219114177997756`*^9, 3.5705352794964375`*^9, {3.570535326354118*^9, 
   3.5705353489564104`*^9}, 3.5705391715720515`*^9, 3.570539343967912*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", "Yt", "]"}], ",", 
     RowBox[{"Im", "[", "Yt", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lom", ",", 
     RowBox[{"-", "3"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5705391783324385`*^9, 3.570539185492848*^9}, {
  3.570539240515995*^9, 3.5705392948041*^9}, {3.5705393617009263`*^9, 
  3.5705394312989073`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81f8XB3BFEQmVUamUUYpEooiXolx7z1D2uDebbK4ZDdfKlpm9CV8t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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0., 0.09999808008992178}, {0., 0.0416808520663291}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Input",
 CellChangeTimes->{{3.570539440369426*^9, 3.5705394424175434`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.570539352817418*^9, 3.57053935284342*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lom", ",", "Z1", ",", "Z2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"lom", ",", 
       RowBox[{"-", "2"}], ",", "6", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.48224695415106*^9, 3.4822470058780184`*^9}, 
   3.482247616006916*^9, 3.482249406678336*^9, {3.4899180741550074`*^9, 
   3.489918075995113*^9}, 3.4899212882048407`*^9, {3.4899214747325096`*^9, 
   3.4899214784287205`*^9}, {3.4899218207332993`*^9, 3.489921838733329*^9}, {
   3.4899218689890594`*^9, 3.4899218743173647`*^9}, {3.5214771395024776`*^9, 
   3.521477155727406*^9}, {3.5218885571592216`*^9, 3.5218885778004026`*^9}, {
   3.521888616026589*^9, 3.5218886178476934`*^9}, 3.52188931853577*^9, 
   3.521889982983774*^9, 3.5219051233047514`*^9, {3.5219114029689274`*^9, 
   3.521911407609193*^9}, 3.521911476249119*^9, {3.570535356419838*^9, 
   3.570535388915696*^9}, 3.5705394635877542`*^9, {3.57053949726768*^9, 
   3.57053949778371*^9}, {3.570539586787801*^9, 3.570539603699768*^9}, 
   3.5705397446258287`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Randles2-Mat.txt\>\"", ",", "res", ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.4822493502621098`*^9, 3.482249404502212*^9, {3.5214771654379616`*^9, 
   3.521477166414017*^9}, {3.5214772797595005`*^9, 3.521477280894565*^9}, {
   3.570535395572077*^9, 3.5705353973291774`*^9}, {3.570539502739993*^9, 
   3.570539506052183*^9}, 3.57053956107633*^9, {3.570539655171712*^9, 
   3.570539663507189*^9}, 3.5705397519122453`*^9}],

Cell[BoxData["\<\"Randles2-Mat.txt\"\>"], "Output",
 CellChangeTimes->{
  3.4822470588200464`*^9, 3.4822494180059843`*^9, 3.4899206141082845`*^9, 
   3.489921297854392*^9, 3.489921507021356*^9, 3.4899219563290553`*^9, 
   3.4899231604799285`*^9, 3.4899232116098533`*^9, {3.489923243844697*^9, 
   3.4899234299013386`*^9}, 3.489923576874745*^9, 3.489924137500811*^9, 
   3.4899242266079073`*^9, {3.489924259050763*^9, 3.4899242800389633`*^9}, 
   3.48992440848431*^9, 3.489924456798074*^9, 3.4899245311753283`*^9, 
   3.489924572106669*^9, 3.4899246228165693`*^9, 3.521477172796382*^9, 
   3.521477284913795*^9, 3.5214822422093363`*^9, 3.521888435924288*^9, {
   3.521888586032873*^9, 3.521888593822319*^9}, 3.5218886267072*^9, 
   3.5218891977378607`*^9, 3.5218893274762816`*^9, 3.521889636575961*^9, 
   3.521889993244361*^9, 3.52189013240032*^9, 3.52189053118713*^9, 
   3.521890635130075*^9, 3.521890901785327*^9, 3.521892393817666*^9, 
   3.5218924793715596`*^9, 3.521892631782277*^9, 3.5218932292434497`*^9, 
   3.521902174817107*^9, 3.521904361425174*^9, {3.521905116755377*^9, 
   3.521905129597111*^9}, 3.5219114182288003`*^9, 3.5705354057616596`*^9, 
   3.570539344568947*^9, 3.570539511388488*^9, 3.570539566442637*^9, 
   3.57053967402779*^9, 3.570539755160431*^9, 3.570539785664176*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[AliasDelimiter]", "\[AliasDelimiter]"}]], "Input",
 CellChangeTimes->{{3.570539514273653*^9, 3.5705395144176617`*^9}}]
}, Open  ]]
},
WindowSize->{1902, 918},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{600, 780}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->2.000000238418579,
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (November 20, 2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 586, 13, 233, "Title"],
Cell[CellGroupData[{
Cell[1178, 39, 589, 10, 213, "Input"],
Cell[1770, 51, 1558, 23, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3365, 79, 1993, 35, 60, "Input"],
Cell[5361, 116, 368, 10, 140, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5766, 131, 144, 3, 60, "Input"],
Cell[5913, 136, 395, 11, 156, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6345, 152, 505, 10, 175, "Input"],
Cell[6853, 164, 767, 11, 85, "Output"],
Cell[7623, 177, 764, 11, 85, "Output"],
Cell[8390, 190, 790, 12, 107, "Output"],
Cell[9183, 204, 767, 11, 85, "Output"],
Cell[9953, 217, 817, 13, 59, "Output"],
Cell[10773, 232, 766, 12, 81, "Output"],
Cell[11542, 246, 745, 11, 59, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12324, 262, 700, 11, 60, "Input"],
Cell[13027, 275, 1072, 15, 85, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14136, 295, 148, 3, 60, "Input"],
Cell[14287, 300, 576, 18, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14900, 323, 148, 3, 60, "Input"],
Cell[15051, 328, 540, 17, 151, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15628, 350, 488, 11, 99, "Input"],
Cell[16119, 363, 1926, 50, 199, "Output"],
Cell[18048, 415, 2085, 53, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20170, 473, 1269, 22, 60, "Input"],
Cell[21442, 497, 10958, 186, 310, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32437, 688, 395, 8, 60, "Input"],
Cell[32835, 698, 1337, 40, 247, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34209, 743, 886, 16, 60, "Input"],
Cell[35098, 761, 14233, 240, 920, "Output"]
}, Open  ]],
Cell[49346, 1004, 94, 1, 60, "Input"],
Cell[CellGroupData[{
Cell[49465, 1009, 523, 11, 60, "Input"],
Cell[49991, 1022, 11133, 189, 268, "Output"]
}, Open  ]],
Cell[61139, 1214, 455, 12, 60, "Input"],
Cell[61597, 1228, 15155, 255, 340, InheritFromParent],
Cell[76755, 1485, 91, 1, 60, InheritFromParent],
Cell[76849, 1488, 1139, 22, 60, "Input"],
Cell[CellGroupData[{
Cell[78013, 1514, 498, 9, 60, "Input"],
Cell[78514, 1525, 1298, 18, 142, "Output"]
}, Open  ]],
Cell[79827, 1546, 144, 2, 60, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
